<?php

declare(strict_types=1);

namespace PackageVersions;

use Composer\InstalledVersions;
use OutOfBoundsException;

class_exists(InstalledVersions::class);

/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see self::rootPackageName()} instead.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = 'concrete5/concrete5';

    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS          = array (
  'anahkiasen/html-object' => '1.4.4@45bb54b91112c064d3906c207259d5c8dcba798f',
  'commerceguys/addressing' => 'v1.3.0@566febd56ca71e31dd383b014c4e1bec680507bf',
  'composer/package-versions-deprecated' => '1.11.99.5@b4f54f74ef3453349c24a845d22392cd31e65f1d',
  'concrete5/dependency-patches' => '1.7.2@ec219a55e89c2552efb7368175c65e68cd2a3de0',
  'concrete5/doctrine-xml' => '1.2.0@03f1209d42477070a58d29e5af15688b96c66b56',
  'concrete5/monolog-cascade' => '0.6.0@2b9836dfab90148e6ae77b62967149329d96fd7d',
  'concrete5/oauth-user-data' => 'v1.0.1@416d5fd707e0b77b06a5be6d4eb9defa4aafb5a8',
  'container-interop/container-interop' => '1.2.0@79cbf1341c22ec75643d841642dd5d6acd83bdb8',
  'dapphp/securimage' => '3.6.8@5fc5953c4ffba1eb214cc83100672f238c184ca4',
  'defuse/php-encryption' => 'v2.3.1@77880488b9954b7884c25555c2a0ea9e7053f9d2',
  'doctrine/annotations' => '1.13.3@648b0343343565c4a056bfc8392201385e8d89f0',
  'doctrine/cache' => '2.1.1@331b4d5dbaeab3827976273e9356b3b453c300ce',
  'doctrine/collections' => '1.6.8@1958a744696c6bb3bb0d28db2611dc11610e78af',
  'doctrine/common' => '3.4.3@8b5e5650391f851ed58910b3e3d48a71062eeced',
  'doctrine/dbal' => '2.13.9@c480849ca3ad6706a39c970cdfe6888fa8a058b8',
  'doctrine/deprecations' => 'v0.5.3@9504165960a1f83cc1480e2be1dd0a0478561314',
  'doctrine/event-manager' => '1.1.1@41370af6a30faa9dc0368c4a6814d596e81aba7f',
  'doctrine/inflector' => '2.0.4@8b7ff3e4b7de6b2c84da85637b59fd2880ecaa89',
  'doctrine/instantiator' => '1.4.1@10dcfce151b967d20fde1b34ae6640712c3891bc',
  'doctrine/lexer' => '1.2.3@c268e882d4dbdd85e36e4ad69e02dc284f89d229',
  'doctrine/migrations' => '2.3.5@28d92a34348fee5daeb80879e56461b2e862fc05',
  'doctrine/orm' => '2.13.3@e750360bd52b080c4cbaaee1b48b80f7dc873b36',
  'doctrine/persistence' => '2.5.5@38670dd6ac8f2d997a0b5b6c98cb380ef0ba9bd3',
  'dragonmantank/cron-expression' => 'v3.3.2@782ca5968ab8b954773518e9e49a6f892a34b2a8',
  'egulias/email-validator' => '1.2.17@19674b35a0a3456be1b96e137098d31ed386fb61',
  'enshrined/svg-sanitize' => '0.15.4@e50b83a2f1f296ca61394fe88fbfe3e896a84cf4',
  'filp/whoops' => '2.14.5@a63e5e8f26ebbebf8ed3c5c691637325512eb0dc',
  'friendsofphp/proxy-manager-lts' => 'v1.0.7@c828ced1f932094ab79e4120a106a666565e4d9c',
  'gettext/gettext' => 'v3.5.9@5b1d69f5889513f7ed65060ad2a662ec3b0875c7',
  'gettext/languages' => '2.9.0@ed56dd2c7f4024cc953ed180d25f02f2640e3ffa',
  'guzzlehttp/guzzle' => '6.5.7@724562fa861e21a4071c652c8a159934e4f05592',
  'guzzlehttp/promises' => '1.5.1@fe752aedc9fd8fcca3fe7ad05d419d32998a06da',
  'guzzlehttp/psr7' => '1.8.5@337e3ad8e5716c15f9657bd214d16cc5e69df268',
  'htmlawed/htmlawed' => '1.2.6@c733124f21c0330be18d7b0f7f0944a19be6791f',
  'illuminate/collections' => 'v8.83.7@fc232e89c0214dba5d2b431220a24b02d480a472',
  'illuminate/config' => 'v8.83.25@feac56ab7a5c70cf2dc60dffe4323eb9851f51a8',
  'illuminate/container' => 'v8.83.25@14062628d05f75047c5a1360b9350028427d568e',
  'illuminate/contracts' => 'v8.83.7@5e0fd287a1b22a6b346a9f7cd484d8cf0234585d',
  'illuminate/filesystem' => 'v8.83.25@73db3e9a233ed587ba54f52ab8580f3c7bc872b2',
  'illuminate/macroable' => 'v8.83.7@aed81891a6e046fdee72edd497f822190f61c162',
  'illuminate/support' => 'v8.83.7@5dd2ffb98c6169f8fcf84c065da3c27289e737af',
  'imagine/imagine' => '1.3.2@ae864f26afbf8859ebd2e2b9df92d77ee175dc13',
  'indigophp/hash-compat' => 'v1.1.0@43a19f42093a0cd2d11874dff9d891027fc42214',
  'jbroadway/urlify' => '1.2.3-stable@b7c142a247bd5fac2bb62ca2491bd151c4d1dee4',
  'laminas/laminas-cache' => '3.1.3@dfd5a66f6ea4b1979231560eb75b615c7aafe0e6',
  'laminas/laminas-cache-storage-adapter-memory' => '2.0.0@f47aed9d5f6f3eac5970693ea5898d67d3f33dcf',
  'laminas/laminas-code' => '3.4.1@1cb8f203389ab1482bf89c0e70a04849bacd7766',
  'laminas/laminas-escaper' => '2.9.0@891ad70986729e20ed2e86355fcf93c9dc238a5f',
  'laminas/laminas-eventmanager' => '3.4.0@a93fd278c97b2d41ebbce5ba048a24e3e6f580ba',
  'laminas/laminas-feed' => '2.17.0@1ccb024ea615606ed1d676ba0fa3f22a398f3ac0',
  'laminas/laminas-i18n' => '2.13.0@b3a55d05818ed37ed18e76c103727e95e32cf591',
  'laminas/laminas-loader' => '2.8.0@d0589ec9dd48365fd95ad10d1c906efd7711c16b',
  'laminas/laminas-mail' => '2.16.0@1ee1a384b96c8af29ecad9b3a7adc27a150ebc49',
  'laminas/laminas-mime' => '2.9.1@72d21a1b4bb7086d4a4d7058c0abca180b209184',
  'laminas/laminas-servicemanager' => '3.7.0@2b0aee477fdbd3191af7c302b93dbc5fda0626f4',
  'laminas/laminas-stdlib' => '3.7.1@bcd869e2fe88d567800057c1434f2380354fe325',
  'laminas/laminas-validator' => '2.17.0@bdd503adc83d814a5c94e598ea0eb9fc7ca56339',
  'laminas/laminas-zendframework-bridge' => '1.4.1@88bf037259869891afce6504cacc4f8a07b24d0f',
  'laravel/helpers' => 'v1.5.0@c28b0ccd799d58564c41a62395ac9511a1e72931',
  'lcobucci/jwt' => '3.4.6@3ef8657a78278dfeae7707d51747251db4176240',
  'league/csv' => '9.7.4@002f55f649e7511710dc7154ff44c7be32c8195c',
  'league/event' => '2.2.0@d2cc124cf9a3fab2bb4ff963307f60361ce4d119',
  'league/flysystem' => '1.1.10@3239285c825c152bcc315fe0e87d6b55f5972ed1',
  'league/flysystem-cached-adapter' => '1.0.9@08ef74e9be88100807a3b92cc9048a312bf01d6f',
  'league/fractal' => '0.19.2@06dc15f6ba38f2dde2f919d3095d13b571190a7c',
  'league/mime-type-detection' => '1.9.0@aa70e813a6ad3d1558fc927863d47309b4c23e69',
  'league/oauth2-server' => '8.3.5@7aeb7c42b463b1a6fe4d084d3145e2fa22436876',
  'league/openid-connect-claims' => '1.1.0@94c25fafdb36d1ee462dc1e74f95709943c1d363',
  'league/pipeline' => '1.0.0@aa14b0e3133121f8be39e9a3b6ddd011fc5bb9a8',
  'league/tactician' => 'v1.0.3@d0339e22fd9252fb0fa53102b488d2c514483b8a',
  'league/uri' => '6.5.0@c68ca445abb04817d740ddd6d0b3551826ef0c5a',
  'league/uri-interfaces' => '2.3.0@00e7e2943f76d8cb50c7dfdc2f6dee356e15e383',
  'league/url' => '3.3.5@1ae2c3ce29a7c5438339ff6388225844e6479da8',
  'lusitanian/oauth' => 'v0.8.11@fc11a53db4b66da555a6a11fce294f574a8374f9',
  'michelf/php-markdown' => '1.9.1@5024d623c1a057dcd2d076d25b7d270a1d0d55f3',
  'mlocati/composer-patcher' => '1.2.4@7b8e063adde96a7bc1c991b070937df9d36098ad',
  'mlocati/concrete5-translation-library' => '1.7.1@877e645dafa8c488385cfdd7c48418d98b335547',
  'mlocati/ip-lib' => '1.18.0@c77bd0b1f3e3956c7e9661e75cb1f54ed67d95d2',
  'mobiledetect/mobiledetectlib' => '2.8.39@0fd6753003fc870f6e229bae869cc1337c99bc45',
  'monolog/monolog' => '1.27.1@904713c5929655dc9b97288b69cfeedad610c9a1',
  'nesbot/carbon' => '2.62.1@01bc4cdefe98ef58d1f9cb31bdbbddddf2a88f7a',
  'pagerfanta/pagerfanta' => 'v2.7.3@5f2aa1f1c9d1a6520f459e84b63e2bc25e9eea5b',
  'paragonie/constant_time_encoding' => 'v2.5.0@9229e15f2e6ba772f0c55dd6986c563b937170a8',
  'paragonie/random_compat' => 'v2.0.21@96c132c7f2f7bc3230723b66e89f8f150b29d5ae',
  'patchwork/utf8' => 'v1.3.3@e1fa4d4a57896d074c9a8d01742b688d5db4e9d5',
  'phpseclib/phpseclib' => '3.0.17@dbc2307d5c69aeb22db136c52e91130d7f2ca761',
  'predis/predis' => 'v1.1.10@a2fb02d738bedadcffdbb07efa3a5e7bd57f8d6e',
  'primal/color' => '1.0.1@dca054972fd09cba33f51675878030305b85030a',
  'psr/cache' => '1.0.1@d11b50ad223250cf17b86e38383413f5a6764bf8',
  'psr/container' => '1.1.1@8622567409010282b7aeebe4bb841fe98b58dcaf',
  'psr/event-dispatcher' => '1.0.0@dbefd12671e8a14ec7f180cab83036ed26714bb0',
  'psr/http-message' => '1.0.1@f6561bf28d520154e4b0ec72be95418abe6d9363',
  'psr/link' => '1.0.0@eea8e8662d5cd3ae4517c9b864493f59fca95562',
  'psr/log' => '1.1.4@d49695b909c3b7628b6289db5479a1c204601f11',
  'psr/simple-cache' => '1.0.1@408d5eafb83c57f6365a3ca330ff23aa4a5fa39b',
  'punic/punic' => '3.8.0@f24eb487f05fafe3ab1cbe33f75a589d50a1677f',
  'ralouphie/getallheaders' => '3.0.3@120b605dfeb996808c31b6477290a714d356e822',
  'sabre/uri' => '2.2.2@7cb0f489578afad5006e85cd60f18ff33f2d440d',
  'sabre/vobject' => '4.5.1@1f836740c88bac483f3b572a332eb8fd1cd04981',
  'sabre/xml' => '2.2.5@a6af111850e7536d200d9637c34885cd3c77a86c',
  'scssphp/scssphp' => 'v1.11.0@33749d12c2569bb24071f94e9af828662dabb068',
  'ssddanbrown/htmldiff' => 'v1.0.2@58f81857c02b50b199273edb4cc339876b5a4038',
  'sunra/php-simple-html-dom-parser' => 'v1.5.2@75b9b1cb64502d8f8c04dc11b5906b969af247c6',
  'symfony/amqp-messenger' => 'v5.4.5@4175a0a98507e7ec575dca9b36e6c0a5a072d3fd',
  'symfony/cache' => 'v5.4.15@60e87188abbacd29ccde44d69c5392a33e888e98',
  'symfony/cache-contracts' => 'v2.5.1@64be4a7acb83b6f2bf6de9a02cee6dad41277ebc',
  'symfony/class-loader' => 'v3.4.47@a22265a9f3511c0212bf79f54910ca5a77c0e92c',
  'symfony/config' => 'v5.4.7@05624c386afa1b4ccc1357463d830fade8d9d404',
  'symfony/console' => 'v5.4.15@ea59bb0edfaf9f28d18d8791410ee0355f317669',
  'symfony/deprecation-contracts' => 'v2.5.1@e8b495ea28c1d97b5e0c121748d6f9b53d075c66',
  'symfony/doctrine-messenger' => 'v5.4.7@bea918cb8363d8fe7953ebcc300454207a3e6093',
  'symfony/error-handler' => 'v5.4.7@060bc01856a1846e3e4385261bc9ed11a1dd7b6a',
  'symfony/event-dispatcher' => 'v5.4.9@8e6ce1cc0279e3ff3c8ff0f43813bc88d21ca1bc',
  'symfony/event-dispatcher-contracts' => 'v2.5.1@f98b54df6ad059855739db6fcbc2d36995283fe1',
  'symfony/filesystem' => 'v5.4.7@3a4442138d80c9f7b600fb297534ac718b61d37f',
  'symfony/finder' => 'v5.4.3@231313534dded84c7ecaa79d14bc5da4ccb69b7d',
  'symfony/http-client' => 'v5.4.7@88b6909f74fd1f2147e068411f71870a3b27ac56',
  'symfony/http-client-contracts' => 'v2.5.1@1a4f708e4e87f335d1b1be6148060739152f0bd5',
  'symfony/http-foundation' => 'v5.4.15@75bd663ff2db90141bfb733682459d5bbe9e29c3',
  'symfony/http-kernel' => 'v5.4.15@fc63c8c3e1036d424820cc993a4ea163778dc5c7',
  'symfony/mercure' => 'v0.6.1@7546092e654f9bb22e554819fb614e462075065a',
  'symfony/messenger' => 'v5.4.14@de4b258a5551934460c422620b61cf0a35744f51',
  'symfony/options-resolver' => 'v5.4.3@cc1147cb11af1b43f503ac18f31aa3bec213aba8',
  'symfony/polyfill-ctype' => 'v1.25.0@30885182c981ab175d4d034db0f6f469898070ab',
  'symfony/polyfill-intl-grapheme' => 'v1.25.0@81b86b50cf841a64252b439e738e97f4a34e2783',
  'symfony/polyfill-intl-idn' => 'v1.25.0@749045c69efb97c70d25d7463abba812e91f3a44',
  'symfony/polyfill-intl-normalizer' => 'v1.25.0@8590a5f561694770bdcd3f9b5c69dde6945028e8',
  'symfony/polyfill-mbstring' => 'v1.25.0@0abb51d2f102e00a4eefcf46ba7fec406d245825',
  'symfony/polyfill-php72' => 'v1.25.0@9a142215a36a3888e30d0a9eeea9766764e96976',
  'symfony/polyfill-php73' => 'v1.25.0@cc5db0e22b3cb4111010e48785a97f670b350ca5',
  'symfony/polyfill-php80' => 'v1.25.0@4407588e0d3f1f52efb65fbe92babe41f37fe50c',
  'symfony/polyfill-php81' => 'v1.25.0@5de4ba2d41b15f9bd0e19b2ab9674135813ec98f',
  'symfony/polyfill-uuid' => 'v1.26.0@a41886c1c81dc075a09c71fe6db5b9d68c79de23',
  'symfony/property-access' => 'v5.4.15@0f3e8f40a1d3da90f674b3dd772e4777ccde4273',
  'symfony/property-info' => 'v5.4.7@0fc07795712972b9792f203d0fe0e77c26c3281d',
  'symfony/psr-http-message-bridge' => 'v2.1.3@d444f85dddf65c7e57c58d8e5b3a4dbb593b1840',
  'symfony/redis-messenger' => 'v5.4.6@6b14778e0a6295af023fec637c7b38f918c1a08d',
  'symfony/routing' => 'v5.4.15@5c9b129efe9abce9470e384bf65d8a7e262eee69',
  'symfony/serializer' => 'v5.4.15@e80871599f6f0929bb349afc3d9ecaba783e68bd',
  'symfony/service-contracts' => 'v2.5.1@24d9dc654b83e91aa59f9d167b131bc3b5bea24c',
  'symfony/stopwatch' => 'v5.4.5@4d04b5c24f3c9a1a168a131f6cbe297155bc0d30',
  'symfony/string' => 'v5.4.3@92043b7d8383e48104e411bc9434b260dbeb5a10',
  'symfony/translation' => 'v5.4.7@e1eb790575202ee3ac2659f55b93b05853726f8e',
  'symfony/translation-contracts' => 'v2.5.1@1211df0afa701e45a04253110e959d4af4ef0f07',
  'symfony/var-dumper' => 'v5.4.6@294e9da6e2e0dd404e983daa5aa74253d92c05d0',
  'symfony/var-exporter' => 'v5.4.7@7eacaa588c9b27f2738575adb4a8457a80d9c807',
  'symfony/web-link' => 'v5.4.3@8b9b073390359549fec5f5d797f23bbe9e2997a5',
  'symfony/yaml' => 'v4.4.45@aeccc4dc52a9e634f1d1eebeb21eacfdcff1053d',
  'tedivm/stash' => 'v0.17.6@a2c9df16c77b13e1f90462f30597a772166eea8f',
  'true/punycode' => 'v2.1.1@a4d0c11a36dd7f4e7cd7096076cab6d3378a071e',
  'tubalmartin/cssmin' => 'v4.1.1@3cbf557f4079d83a06f9c3ff9b957c022d7805cf',
  'voku/portable-ascii' => '1.6.1@87337c91b9dfacee02452244ee14ab3c43bc485a',
  'voku/stop-words' => '2.0.1@8e63c0af20f800b1600783764e0ce19e53969f71',
  'webmozart/assert' => '1.10.0@6964c76c7804814a842473e0c8fd15bab0f18e25',
  'wikimedia/composer-merge-plugin' => 'v2.0.1@8ca2ed8ab97c8ebce6b39d9943e9909bb4f18912',
  'wikimedia/less.php' => '1.8.2@e238ad228d74b6ffd38209c799b34e9826909266',
  'concrete5/core' => 'dev-master@219184a08d4585d3d460b5540794fad3a7041df7',
  'laminas/laminas-cache-storage-adapter-apc' => '*@219184a08d4585d3d460b5540794fad3a7041df7',
  'laminas/laminas-cache-storage-adapter-apcu' => '*@219184a08d4585d3d460b5540794fad3a7041df7',
  'laminas/laminas-cache-storage-adapter-blackhole' => '*@219184a08d4585d3d460b5540794fad3a7041df7',
  'laminas/laminas-cache-storage-adapter-dba' => '*@219184a08d4585d3d460b5540794fad3a7041df7',
  'laminas/laminas-cache-storage-adapter-ext-mongodb' => '*@219184a08d4585d3d460b5540794fad3a7041df7',
  'laminas/laminas-cache-storage-adapter-filesystem' => '*@219184a08d4585d3d460b5540794fad3a7041df7',
  'laminas/laminas-cache-storage-adapter-memcache' => '*@219184a08d4585d3d460b5540794fad3a7041df7',
  'laminas/laminas-cache-storage-adapter-memcached' => '*@219184a08d4585d3d460b5540794fad3a7041df7',
  'laminas/laminas-cache-storage-adapter-mongodb' => '*@219184a08d4585d3d460b5540794fad3a7041df7',
  'laminas/laminas-cache-storage-adapter-redis' => '*@219184a08d4585d3d460b5540794fad3a7041df7',
  'laminas/laminas-cache-storage-adapter-session' => '*@219184a08d4585d3d460b5540794fad3a7041df7',
  'laminas/laminas-cache-storage-adapter-wincache' => '*@219184a08d4585d3d460b5540794fad3a7041df7',
  'laminas/laminas-cache-storage-adapter-xcache' => '*@219184a08d4585d3d460b5540794fad3a7041df7',
  'laminas/laminas-cache-storage-adapter-zend-server' => '*@219184a08d4585d3d460b5540794fad3a7041df7',
  'concrete5/concrete5' => 'dev-master@219184a08d4585d3d460b5540794fad3a7041df7',
);

    private function __construct()
    {
    }

    /**
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function rootPackageName() : string
    {
        if (!self::composer2ApiUsable()) {
            return self::ROOT_PACKAGE_NAME;
        }

        return InstalledVersions::getRootPackage()['name'];
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName): string
    {
        if (self::composer2ApiUsable()) {
            return InstalledVersions::getPrettyVersion($packageName)
                . '@' . InstalledVersions::getReference($packageName);
        }

        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }

    private static function composer2ApiUsable(): bool
    {
        if (!class_exists(InstalledVersions::class, false)) {
            return false;
        }

        if (method_exists(InstalledVersions::class, 'getAllRawData')) {
            $rawData = InstalledVersions::getAllRawData();
            if (count($rawData) === 1 && count($rawData[0]) === 0) {
                return false;
            }
        } else {
            $rawData = InstalledVersions::getRawData();
            if ($rawData === null || $rawData === []) {
                return false;
            }
        }

        return true;
    }
}
